#if !defined (ACMAPORCLAPITESTTOOLS_HEADER)
#define ACMAPORCLAPITESTTOOLS_HEADER

///////////////////////////////////////////////////////////////////////////////
// (C) Copyright 2001 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// CREATED BY:
//	Hugues Wisniewski, June 2001
//
// DESCRIPTION:
// 	Declaration of namespace AcMapFlatOrclApiTestTools

#include <string>
#include <vector>

namespace AcMapFlatOrclApiTestTools
{
	BOOL FindAndOpenSqlWhereClauseSamplesFile(
		CStdioFile& whereClauseSamplesFile,
		LPCTSTR	szFileName,
		BOOL bIncludeSubDirs);
	BOOL FindAndOpenSqlWhereClauseSamplesFile(
		CStdioFile& whereClauseSamplesFile,
		const CString& cszBaseDirectory, 
		LPCTSTR	szFileName,
		BOOL bIncludeSubDirs);
	BOOL IsDotDirectory(LPWIN32_FIND_DATA pData);
	void CheckEndSlash(CString& cszDirectory);
	bool FillColumnNamesDataTypes(
		const std::string& strTableName, 
		std::vector<std::string>& vectColumnNames,
		std::vector<std::string>& vectDataTypes, 
		bool bUpperCase);
	bool GetListStringValuesFromTableColumn(
		const std::string& strTableName,
		const std::string& strColumnName,
		std::vector<std::string>& vectValues);
	bool GetListStringValuesFromTable(
		const std::string& strTableName,
		const std::string& strQuery,
		std::vector<std::string>& vectValues);
	bool ReadAllSampleSqlWhereClauses(
		std::vector<CString>& vectSqlWhereClauses,
		std::vector<CString>& vectSqlWhereClausesTitles);
}

#endif //ACMAPORCLAPITESTTOOLS_HEADER